/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* LLF_ECPKI_GenKeyPair() function. 
*
* \version LLF_ECPKI_KG.c#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "LLF_ECPKI_KG.h"
#include "LLF_ECPKI_Common.h"

/************************ Defines *****************************/
//#define LLF_PRNG_BUFFER_SIZE 16
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_GenKeyPair
*
* Inputs:
* @param DomainID [in] - The enumerator variable defines the current EC domain;
* @param UserPrivKey_ptr [out] - A pointer to the output private key structure.
* @param UserPublKey_ptr [out] - A pointer to the otput public key structure.
*
* Outputs:
* @returns \b CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*
* \brief \b 
* Description:
*  This function generate new key pair for ECC.
*
* \b 
* Algorithm:
*  -# Imports CE2 keys to LibTomCrypt format;
*  -# Create shared secret.
***************************************************************/
CE2Error_t LLF_ECPKI_GenKeyPair(
	CE2_ECPKI_DomainID_t  	    DomainID,	        /*in*/   
	CE2_ECPKI_UserPrivKey_t   *UserPrivKey_ptr,    /*out*/
	CE2_ECPKI_UserPublKey_t   *UserPublKey_ptr    /*out*/)
{
  prng_state prng;
  ecc_key  key;
  int error_code, wprng;
  CE2Error_t error = CE2_OK, result = CE2_OK;

  /* Initialize ltc_mp structure */
  ltc_mp = ltm_desc;

  /* Create and initialize Pseudo-Random Number Generators.
    It needs for generation of new key pair */
  error = LLF_ECPKI_PRNG_Init(&prng, &wprng);
  if (error != CE2_OK) {
    fortuna_done(&prng);
    return CE2_LLF_ECPKI_MODULE_ERROR_BASE;
  }

  /* Generation of new key pair */
  error_code = ecc_make_key(&prng, wprng, (DomainID_t)DomainID, &key);
  if(error_code != CRYPT_OK) {
    result = CE2_LLF_ECPKI_MODULE_ERROR_BASE;
    goto error_case;
  }

  /* Convert LibTomCrypt key to CE2 format */
  error_code = ecc_export(UserPrivKey_ptr->PrivKeyDbBuff, 
    &(UserPrivKey_ptr->valid_tag) ,PK_PRIVATE, &key);
  if(error_code != CRYPT_OK) {
    result = CE2_LLF_ECPKI_MODULE_ERROR_BASE;
    goto error_case;
  }

  error_code = ecc_export(UserPublKey_ptr->PublKeyDbBuff, 
    &(UserPublKey_ptr->valid_tag) ,PK_PUBLIC, &key);
  if(error_code != CRYPT_OK) {
    result = CE2_LLF_ECPKI_MODULE_ERROR_BASE;
    goto error_case;
  }

error_case:
  fortuna_done(&prng);
  ecc_free(&key);
  return result;
} /* End of LLF_ECPKI_GenKeyPair */
